/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.CSVRecord;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;

public class PILEDChange {
    private static final int NUM_VALID_PARMS = 6;
    private String m_resourceType;
    private String m_managedSystem;
    private String m_operation;
    private String m_saType;
    private String m_partitionId;
    private String m_partitionName;
    private Integer[] m_stateArry;
    private String[] m_lparArry;
    private short m_state;
    private HashMap m_validParms = new HashMap(13, 0.5f);
    private PIHSCCECClient m_cecClient = null;
    private static final String ON_OPERATION = "on";
    private static final String OFF_OPERATION = "off";
    private PrintStream m_out;
    private boolean m_writeStatus;

    private PILEDChange(PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_cecClient = pIHSCCECClient;
        this.m_out = printStream;
        this.m_writeStatus = bl;
        this.m_validParms.put("-r", null);
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-o", null);
        this.m_validParms.put("-t", null);
        this.m_validParms.put("--id", null);
        this.m_validParms.put("-p", null);
    }

    private void doSystemOperations() throws PIHscClientException {
        PICECDataBean pICECDataBean = this.m_cecClient.getCECDataBean(new String[]{"state"});
        int n = pICECDataBean.getCecState().intValue();
        if (this.m_saType.equals("phys") || this.m_saType.equals("virtualsys")) {
            if (n == 254 || n == 241 || n == 242 || n == 250) {
                String[] stringArray = new String[]{pICECDataBean.getCECStateString()};
                throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0237", stringArray, null);
            }
        } else if (n != 17 && n != 1) {
            throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "9010", null, null);
        }
        if (this.m_saType.equals("phys")) {
            System.out.println("CALL Client set on");
            this.m_cecClient.setSALEDState((short)1, this.m_state);
        } else if (this.m_saType.equals("virtualsys")) {
            System.out.println("CALL client set off Virtual SYS");
            this.m_cecClient.setSALEDState((short)2, this.m_state);
        } else if (this.m_saType.equals("virtuallpar")) {
            System.out.println("CALL client set on Virtual LPAR");
            this.m_cecClient.setVirtualPartitionSALEDStates(this.m_lparArry, this.m_stateArry, this.m_partitionId != null);
        }
    }

    private void performCommand() throws PIHscClientException {
        this.checkParameters();
        if ("sa".equals(this.m_resourceType)) {
            this.doSystemOperations();
        }
        if (this.m_writeStatus) {
            this.m_writeStatus = false;
            this.m_out.print('\u0000');
        }
    }

    private void checkParameters() throws PIHscClientException {
        String[] stringArray = null;
        String string = new String();
        if (null == this.m_resourceType) {
            string = string + "-r";
        }
        if (null == this.m_managedSystem) {
            string = string + ", -m";
        }
        if (null == this.m_operation) {
            string = string + ", -o";
        }
        if (null == this.m_saType) {
            string = string + ", -t";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        string = new String();
        if (this.m_resourceType != null && !this.m_resourceType.equals("sa")) {
            string = string + ", -r";
        }
        if (this.m_resourceType.equals("sa") && null != this.m_saType && !this.m_saType.equals("phys") && !this.m_saType.equals("virtuallpar") && !this.m_saType.equals("virtualsys")) {
            string = string + ", -t";
        }
        if (!this.m_operation.equals(ON_OPERATION) && !this.m_operation.equals(OFF_OPERATION)) {
            string = string + ", -o";
        } else if (this.m_saType.equals("phys") && !this.m_operation.equals(OFF_OPERATION)) {
            string = string + ", -o";
        }
        if (this.m_saType.equals("virtuallpar") && null == this.m_partitionId && null == this.m_partitionName) {
            string = string + ", -p or --id";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
    }

    private void mapParameters(HashMap hashMap) {
        int n;
        CSVRecord cSVRecord = null;
        Object[] objectArray = null;
        this.m_resourceType = (String)hashMap.get("-r");
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_operation = (String)hashMap.get("-o");
        this.m_saType = (String)hashMap.get("-t");
        this.m_partitionId = (String)hashMap.get("--id");
        this.m_partitionName = (String)hashMap.get("-p");
        if (null != this.m_partitionId) {
            cSVRecord = new CSVRecord(this.m_partitionId);
            objectArray = cSVRecord.toArray();
            this.m_lparArry = new String[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                this.m_lparArry[n] = (String)objectArray[n];
            }
            this.m_stateArry = new Integer[this.m_lparArry.length];
        } else if (null != this.m_partitionName) {
            cSVRecord = new CSVRecord(this.m_partitionName);
            objectArray = cSVRecord.toArray();
            this.m_lparArry = new String[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                this.m_lparArry[n] = (String)objectArray[n];
            }
            this.m_stateArry = new Integer[this.m_lparArry.length];
        } else {
            this.m_stateArry = new Integer[1];
        }
        this.m_state = null != this.m_operation && this.m_operation.equals(ON_OPERATION) ? ("virtuallpar".equals(this.m_saType) ? (short)1 : (short)2) : (short)0;
        for (n = 0; n < this.m_stateArry.length; ++n) {
            this.m_stateArry[n] = new Integer(this.m_state);
        }
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CHLED_HELP"));
    }

    public static int callCommandFromRouter(PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PILEDChange pILEDChange = new PILEDChange(pIHSCCECClient, printStream, bl);
        int n = 0;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pILEDChange.m_validParms);
            pILEDChange.mapParameters(hashMap);
            pILEDChange.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                bl = false;
                printStream.print('\u0001');
            }
            pIHscClientException.printStackTrace(System.out);
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                bl = false;
                printStream.print('\u0001');
            }
            exception.printStackTrace(System.out);
            String string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }
}

